<?php

namespace App\Http\Controllers\Site\Student\TC;

use App\Models\Image\Photo;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\TC\SiteStudentTC;
use App\Models\Site\TC\SiteTcSetting;
use App\Models\Student\StudentHistory;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Image;
use Response;

class StudentTCController extends Controller
{
    private $SiteStudentTC;
    private $tcSetting;

    public function __construct(SiteStudentTC $studentTC, SiteTcSetting $tcSetting)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->carbon_now = Carbon::now();
        $this->studentTC = $studentTC;
        $this->tcSetting = $tcSetting;


    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Student TC';
        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.site.student.TC.index',compact('viewType'));
    }


    public function getTCDataList(Request $request)
    {
        $siteStudentIDs = $this->returnSiteStudentIDs($request);
        $stdNumbers = $siteStudentIDs->count();
        return [$siteStudentIDs, $stdNumbers];
    }

    private function returnSiteStudentIDs(Request $request)
    {

        $data = $request->all();


        if ($request->academic_class_id) {

            if ($request->academic_class_group_present) {

                $siteStudentIDs = StudentHistory::with(['student' => function ($query) {
                    $query->select('id');
                }])
                    ->where('academic_version_id', $request->academic_version_id)
                    ->where('academic_shift_id', $request->academic_shift_id)
                    ->where('academic_year_id', $request->academic_year_id)
                    ->where('academic_class_id', $request->academic_class_id)
                    ->where('status', true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->get(['id', 'user_id']);


            } else {

                $siteStudentIDs = StudentHistory::with(['student' => function ($query) {
                    $query->select('id');
                }])
                    ->where('academic_version_id', $request->academic_version_id)
                    ->where('academic_shift_id', $request->academic_shift_id)
                    ->where('academic_year_id', $request->academic_year_id)
                    ->where('academic_class_id', $request->academic_class_id)
                    ->where('status', true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->get(['id', 'user_id']);

            }

        }

        return $siteStudentIDs;

    }

    public function getTcSettingList()
    {
        $setting_data_list = $this->tcSetting->get();
        return $setting_data_list;
    }


    public function createTcSetting(Request $request)
    {
//        return $request;
        if (strlen($request->authority_signature) <200 ) {
            $fileName = $request->authority_signature;
        } else {
            $name = time() . '.' . explode('/', explode(':', substr($request->authority_signature, 0, strpos($request->authority_signature, ';')))[1])[1];
            $fileName = '/img/signature/' . $name;
            Image::make($request->authority_signature)->resize(235, 40)->save(public_path('/img/signature/') . $name);
        }


//        return $fileName;

        $this->tcSetting->create([
            'setting_name' => $request->setting_name,
            'heading' => $request->heading,
            'body_starting' => $request->body_starting,
            'body_ending' => $request->body_ending,
            'conclusion' => $request->conclusion,
            'authority_name' => $request->authority_name??null,
            'authority_signature' => $fileName??null,
            'create_date' => Carbon::today(),
            'created_by' => Auth::user()->id,
            'status' => 1,
        ]);

        return Response::json(['message' => 'Site information Save Successfully!', 'mode' => 'Saved!'], 200);

    }

    public function updateTcSetting(Request $request)
    {


        if (strlen($request->authority_signature) <200 ) {
            $fileName = $request->authority_signature;
        } else {
            $name = time() . '.' . explode('/', explode(':', substr($request->authority_signature, 0, strpos($request->authority_signature, ';')))[1])[1];
            $fileName = '/img/signature/' . $name;
            Image::make($request->authority_signature)->resize(235, 40)->save(public_path('/img/signature/') . $name);
        }

//        return $fileName;

        $this->tcSetting->where('id', $request->id)->update([
            'setting_name' => $request->setting_name,
            'heading' => $request->heading,
            'body_starting' => $request->body_starting,
            'body_ending' => $request->body_ending,
            'conclusion' => $request->conclusion,
            'authority_name' => $request->authority_name??null,
            'authority_signature' => $fileName??null,
            'create_date' => Carbon::today(),
            'created_by' => Auth::user()->id,
            'status' => 1,
        ]);
        return Response::json(['message' => 'Site information Save Updated!', 'mode' => 'Updated!'], 200);

    }



    //==========================TC Application=============

    private function classGroupSectionValidation($request){

        $check_group_section=SiteShiftClassGroupSectionSetting::
        where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->first();

        if($check_group_section->academic_department_id && !$request->academic_department_id){
            return Response::json(['message' => 'Plese Select Department!', 'mode' => 'Error'], 200);
        }

        if($check_group_section->academic_class_group_id && !$request->academic_class_group_id){
            return Response::json(['message' => 'Plese Select Group!', 'mode' => 'Error'], 200);
        }

        if($check_group_section->academic_section_ids && !$request->academic_section_id){
            return Response::json(['message' => 'Plese Select Section!', 'mode' => 'Error'], 200);
        }

    }





    public function getStudentListForTcApplication(Request $request){

        $data=$request->all();

        $valiedation=$this->classGroupSectionValidation($request);
        if($valiedation){

            return $valiedation;
        }


        $student_list = StudentHistory::with(['student'=>function($query){
            $query->select('id');
        }])
            ->select('id', 'user_id', 'student_roll_number', 'student_roll_number_prefix',
                'registration_no', 'board_registration_number', 'board_roll_number')
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_class_group_id', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('student_roll_number', 'ASC')
            ->get();



        return $student_list;

    }




}
